% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program costfunction.m
function L = costfunction(initial_guess, P_iHj)
 
d = [0 initial_guess];    % distance of the first spatial 
                          % frequency is defined to be 0.
zData = norminv(P_iHj);   % z_iHj is obtained from P_iHj through z-transformation
 
L = 0;
for i = 1:7
    for j = 1:7
        z(i, j) = sqrt(2) * (d(j) - d(i));
        L = L + (zData(i, j) - z(i,j))^2;
    end
end
 
r2 = 1 - L/sum(sum((z(i,j) - mean2(zData)).^2));
